<?php
require_once '../auth/auth.php';
require_once '../models/db_connection.php';
require_once '../models/student_model.php';
$student =  new Student($conn);
$studentsData = $student->getAllStudents();
?>

<!DOCTYPE html>
<html lang="en">

<head>
	<title>Student | Add Student </title>
	<?php include("../templates/header.php"); ?>
	<script type='text/javascript'>
		function ConfirmDelete() {
			if (confirm("Are you sure you want to delete this student and its associated details?"))
				return true;
			else
				return false;
		}
	</script>
</head>

<body>
	<?php
	if (isset($_GET["message"])) {
		$message = $_GET["message"];
		echo "<script>alert('" . $message . "')</script>";
	}
	?>
	<div class="container-scroller">
		<!-- partial:partials/_navbar.html -->
		<?php include("../templates/nav.php"); ?>
		<!-- partial -->
		<div class="container-fluid page-body-wrapper">
			<!-- partial:partials/_sidebar.html -->
			<?php include("../templates/sidenav.php"); ?>
			<!-- partial -->
			<div class="main-panel">
				<div class="content-wrapper">

					<div class="col-lg-12 grid-margin stretch-card">
						<div class="card">
							<div class="card-body">
								<h4 class="card-title">View All Students</h4>
								<p class="card-description">
									Students Table <code></code>
								</p>
								<div class="table-responsive pt-3">
									<table class="table table-bordered display" id="example" style="width:100%">
										<thead>
											<tr>
												<th> # </th>
												<th>Student Details</th>
												<th>Course enrolled</th>
												<th>Enrollment</th>
												<th> Reg By</th>
												<th>Actions</th>
											</tr>
										</thead>
										<tbody>
											<?php
											$x = 1;
											$studentsData = mysqli_query($conn, "SELECT * FROM students 
                                         LEFT JOIN student_course ON students.en_id = student_course.s_id 
                                         LEFT JOIN fees ON fees.id = student_course.course_id");
											while ($studentValue = mysqli_fetch_array($studentsData)) {

												//$isEnrolled = $student->isStudentEnrolled($studentValue['student_id']);
											?>
												<tr>
													<td> <?= $x ?></td>
													<td>Enrollment ID: <?= $studentValue['en_id'] ?>,Full name: <?= $studentValue['fullname'] ?>,
														ID NO: <?= $studentValue['ident_number'] ?>, Street: <?= $studentValue['street'] ?>,
														Work: <?= $studentValue['work'] ?>, Address: <?= $studentValue['address'] ?>,
														Education: <?= $studentValue['education'] ?></td>
													<td>
														<?= isset($studentValue['name']) ? $studentValue['name'] : 'No course assigned' ?>
													</td>
													<td><label class="badge <?php if ($studentValue['status'] == 'enrolled') {
																				echo 'badge-success';
																			} else {
																				echo 'badge-danger';
																			} ?>"><?= $studentValue['status'] ?></label></td>
													<td><?= $studentValue['reg_by'] ?></td>

													<td>
														<?php
														if ($studentValue['status'] == 'enrolled') {
														?>
															<a href="single_student.php?id=<?= $studentValue['student_id'] ?>">
																<button type="button" class="btn btn-outline-primary btn-icon-text">
																	<i class="fa fa-eye"></i> </button></a>
														<?php
														}
														?>
														<a href="edit_student.php?id=<?= $studentValue['student_id'] ?>">
															<button  type="button" class="btn btn-outline-secondary btn-icon-text">
																<i class=" fa fa-pencil"></i> </button></a>

														<a onclick='return ConfirmDelete()' href="../controllers/delete_student.php?id=<?= $studentValue['student_id'] ?>">
															<button <?php if ($_SESSION['role'] != 'admin') {
																		echo "disabled";
																	} ?> type="button" class="btn btn-primary btn-icon-text">
																<i class="fa fa-trash"></i> </button></a>


													</td>
												</tr>
											<?php $x++;} ?>


										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!-- content-wrapper ends -->
				<!-- partial:partials/_footer.html -->
				<?php include("../templates/footer.php"); ?>

				<!-- partial -->
			</div>
			<!-- main-panel ends -->
		</div>
		<!-- page-body-wrapper ends -->
	</div>
	<?php include("../templates/inc_scripts.php"); ?>

	<script>
		new DataTable('#example');
	</script>
</body>

</html>