<?php 
require_once('db_connection.php');
class Student  
{
    private $db;
    function __construct($dbconn){
        $this->db = $dbconn;
    }

    // Function to fetch all students
    public function getAllStudents() {
        $query = "SELECT * FROM students";
        $result =  mysqli_query($this->db,$query);
        $data = mysqli_fetch_all( $result,MYSQLI_ASSOC);
        return $data;
    }
    public function getSingleStudent($id) {
        $query = "SELECT * FROM `student_course` 
        JOIN students ON students.student_id = student_course.student_id
        WHERE student_course.student_id = $id";
        $result =  mysqli_query($this->db,$query);
        $data = mysqli_fetch_all( $result,MYSQLI_ASSOC);
        return $data;
    }

 public function createStudent($enrollmentId, $fullname, $identNumber, $street, $address, $work, $education, $gender, $phoneNumber, $eyeProblems, $earProblems, $sensitiveCase,$filename,$user,$age) {
        $query = "INSERT INTO students (en_id, fullname, ident_number, street, address, work, education, gender, phone_number, eye_problems, ear_problems, sensitive_case,filename,reg_by,age) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("sssssssssssssss", $enrollmentId, $fullname, $identNumber, $street, $address, $work, $education, $gender, $phoneNumber, $eyeProblems, $earProblems, $sensitiveCase,$filename,$user,$age);
        
        // Execute the statement
       if ($stmt->execute()) {
        return array("success" => true, "message" => "Student created successfully");
    } else {
        return array("success" => false, "message" => $stmt->error); // Failed to create student, return error message
    }
    }


    public function editStudent($studentId,$fullname,$identNumber,$street,$address,$work,$education,$gender,$phoneNumber,$eyeProblems,$earProblems,$sensitiveCase,$file_name,$certnumber) {
            // Query to update the student record
                $query = "UPDATE students SET 
                fullname = '$fullname',
                ident_number = '$identNumber',
                street = '$street',
                address = '$address',
                work = '$work',
                education = '$education',
                gender = '$gender',
                phone_number = '$phoneNumber',
                eye_problems = '$eyeProblems',
                ear_problems = '$earProblems',
                en_id = '$certnumber',
                sensitive_case = '$sensitiveCase'";
                
            // If a new image is uploaded, update the image field
            if ($file_name !== '') {
            $query .= ", filename = '$file_name'";
            }
                
            $query .= " WHERE student_id = $studentId";

            
           $result =  mysqli_query($this->db,$query);
           return $result;

        }

    public function generateEnrollmentId($length = 6) {
        // Define characters allowed in the enrollment ID
        $generalForm = "REG-TRD/A.21/MWZ/2010/";

        $query = "SELECT MAX(student_id) AS last_id FROM students";
        $result = mysqli_query($this->db,$query);
        $row = mysqli_fetch_array($result);
        $last_id =  $row[0];
        $enrollmentId = $generalForm.$last_id;

    
        return $enrollmentId;
    }

     // Function to return student ID given enrollment ID
     public function getStudentIdByEnrollmentId($enrollmentId) {
        $query = "SELECT student_id FROM students WHERE en_id = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("s", $enrollmentId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return $row['student_id']; // Return student ID
        } else {
            return null; // No student found with the given enrollment ID
        }
    }

    public function isStudentEnrolled($studentId) {
        $query = "SELECT * FROM student_course WHERE student_id = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("s", $studentId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            return true; // Student is enrolled
        } else {
            return false; // Student is not enrolled
        }
    }

    public function deleteStudent($studentId) {
        $query = "DELETE FROM students WHERE `students`.`student_id` = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("s", $studentId);
        $stmt->execute();
        $result = $stmt->get_result();

        return $result;
    }


    
    


}





