<?php
require_once '../auth/auth.php';
require_once '../models/db_connection.php';
require_once '../models/student_model.php';
require_once '../models/exam_model.php';
require_once '../models/course_model.php';

$course =  new Course($conn);
$coursesData =  $course->getAllCourses();
$student =  new Student($conn);
$studentsData = $student->getAllStudents();
$exam =  new Exam($conn);

// var_dump($studentRes);
// die();


if (isset($_POST["search"])) {

  $year = $_POST["year"];
  $courseID = $_POST["courseID"];

  $_SESSION['year'] = $year;
  $_SESSION['courseID'] = $courseID;

  $studentsData =  $course->getAllStudentsByCourseAndYear($courseID, $year);

  // var_dump($studentsData);
  // die();

}




?>

<!DOCTYPE html>
<html lang="en">

<head>
  <title>Student | Add Student </title>
  <?php include("../templates/header.php"); ?>
</head>

<body>
  <?php
  if (isset($_GET["message"])) {
    $message = $_GET["message"];
    echo "<script>alert('" . $message . "')</script>";
  }
  ?>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include("../templates/nav.php"); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include("../templates/sidenav.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <!-- <div class="col-md-6 grid-margin stretch-card">
        <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Search Students</h4>
                  <p class="card-description"> 
                    Search students to add <code>Marks</code>                   
                  </p>
                  <form action="generate_results.php" method="POST">
                  <div class="form-group">
                    <label for="exampleFormControlSelect2">Enrollment Year</label>
                  
                    <input name="year" required class="form-control" type="text">
                  </div>
                  <div class="form-group">
                    <label for="exampleFormControlSelect2">Course</label>
                    <select class="form-control" id="exampleFormControlSelect2" name="courseID">
                      <?php
                      foreach ($coursesData as $courseValue) { ?>
                        <option value="<?= $courseValue['course_id'] ?>" ><?= $courseValue['name'] ?></option>
                     <?php  } ?>
                    </select>
                  </div>
                  
                  <div class="col-sm-9">
                          <button <?php if ($_SESSION['role'] != 'admin') {
                                    echo "disabled";
                                  } ?>  type="submit" name="search" class="btn btn-dark btn-lg ">Generate</button>
                  </div>
                </div>
                </form>
              </div>
        </div> -->

          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">View Students Results</h4>
                <p class="card-description">
                  Students Table <code></code>
                </p>
                <div class="table-responsive pt-3">
                  <table class="table table-bordered display" id="example" style="width:100%">
                    <thead>
                      <tr>
                        <th> # </th>
                        <th>Enrollment ID</th>
                        <th> Fullname</th>
                        <th> Practical</th>
                        <th> Theory</th>
                        <th> Average</th>
                        <th> Remarks</th>
                        <?php if ($_SESSION['role'] == 'admin') {
                            ?>
                        <th> Action</th>
                        <?php
                        }
                        ?>


                      </tr>
                    </thead>
                    <?php  //if(isset($_POST['search'])) {
                    ?>
                    <tbody>
                      <?php
                      $x = 1;
                      $getstudent = mysqli_query($conn, "SELECT * FROM students,student_exams WHERE students.student_id = student_exams.student");
                      while ($fetch = mysqli_fetch_array($getstudent)) {
                      ?>
                        <tr>
                          <td> <?php echo $x ?></td>
                          <td><?php echo $fetch['en_id'] ?></td>
                          <td><?php echo $fetch['fullname'] ?></td>
                          <td><?php echo $fetch['practical'] ?></td>
                          <td><?php echo $fetch['theory']  ?></td>
                          <td>
                            <?php
                            echo $fetch['average'];
                            ?>
                          </td>

                          <td>
                            <?php
                            $x++;
                            if ($fetch['average'] >= 70) {
                              echo  "<label class='badge badge-success'>Passed</label>";
                            } else {
                              echo    "<label class='badge badge-danger'>Failed</label>";
                            }
                            ?>
                          </td>
                          <?php if ($_SESSION['role'] == 'admin') {
                            ?>
                          <td>
                            <a href="../controllers/results.php?id=<?php echo $fetch['id']  ?>" class="btn btn-dark btn-lg">Print Result</a>
                            
                          </td>
                          <?php
                          }
                          ?>
                        </tr>
                        <?php }
                        ?>


                    </tbody>
                  <?php //} ?>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <?php include("../templates/footer.php"); ?>

        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <?php include("../templates/inc_scripts.php"); ?>
  <script>
    new DataTable('#example');
  </script>
</body>

</html>