<?php
// Include the FPDF library
require('../fpdf186/fpdf.php');
session_start();
require_once '../models/db_connection.php';
require_once '../models/student_model.php';
require_once '../models/exam_model.php';
require_once '../models/course_model.php';

$course =  new Course($conn);
$coursesData =  $course->getAllCourses();
$student =  new Student($conn);
$studentsData = $student->getAllStudents();
$exam =  new Exam($conn);
$year = $_SESSION['year'] ;
$courseID = $_SESSION['courseID'] ;

$studentsData =  $course->getAllStudentsByCourseAndYear($courseID, $year);




// Create a new PDF instance
$pdf = new FPDF();

// Define the number of pages you want to generate
$numPages = 4;
$certNO = 1;
// Loop through each page
foreach ($studentsData as $studentValue) {
    $isEnrolled = $student->isStudentEnrolled($studentValue['student_id']);
    $studentRes = $exam->generateResults($studentValue['student_id']);
    if ($studentRes['average'] < 70) {
      continue;
    }
    $pdf->AddPage();

    // Set font for the text
    $pdf->SetFont('Arial', '', 16);

    // Add certificate image as background
    $pdf->Image('certificate_template.jpg', 0, 0, $pdf->GetPageWidth(), $pdf->GetPageHeight());

    // Add centificate number
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(135, 95); // Adjust X and Y coordinates to position the text
     $pdf->Cell(0, 10, 'CERT NO '. str_pad(end(explode("/", $studentValue['en_id'])), 4, '0', STR_PAD_LEFT), 0, 1, 'C');
    $certNO ++;
    // Add Registration number
    $pdf->SetTextColor(0, 0, 255);
    $pdf->SetFont('Arial', '', 9);
    $pdf->SetXY(10, 80); // Adjust X and Y coordinates to position the text
    $pdf->Cell(0, 10, "REG-TRD/A.21/MWZ/2010/54" , 0, 1, 'C');

    // Add student image
    $pdf->Image("../uploads/".$studentValue['filename'], 155, 60, 28, 35);

    // Add student Name
    $pdf->SetFont('Times', 'B', 22);
    $pdf->SetTextColor(255, 0, 0);
    $pdf->SetXY(10, 125); // Adjust X and Y coordinates to position the text
    $pdf->Cell(0, 10,strtoupper($studentValue['fullname']), 0, 1, 'C');

    //date of completion
    $pdf->SetFont('Arial', 'I', 14);
    $pdf->SetTextColor(0, 0, 255);
    $pdf->SetXY(10, 163); // Adjust X and Y coordinates to position the text
    $pdf->Cell(0, 10, 'FROM ' . (new DateTime($studentValue['en_date']))->format("d/m/Y") . ' TO ' . date("d/m/Y"), 0, 1, 'C');
    // $pdf->Cell(0, 10, 'FROM '. (new DateTime($studentValue['en_date']))->format("d/m/Y") . ' TO '. Date("d/m/Y"), 0, 1, 'C');
}

// Output the PDF to the browser
$pdf->Output();


?>
